import { View, Text, Pressable } from "react-native";
import React, { useState } from "react";
import { ProductsStyle } from "../../../screens/Home/FeaturedProducts/featureProductsStyle";
import { singleProductStyle } from "./singleProduct.style";
import ProgressiveImage from "../ProgressiveImage";
import CustomRating from "../../../screens/Utilities/CustomRating/CustomRating";
import { memo } from "react";
import dpr from "../../../screens/Utilities/CustomStyleAttribute/dpr";
import { compareWithTodaysDate } from "../../../helper/compareWithTodaysDate";
import ProductBadge from "./ProductBadge";
import { PRODUCT_DETAILS } from "../../../components/Navigation/RouteNames";

const SingleProduct = (props) => {
    const { item, navigation } = props || {};
    const {
        type,
        slug,
        featured_image,
        name,
        regular_price_formatted,
        sale_price_formatted,
        isOutOfStock,
        featured,
        offerCheck,
        discountPercent,
        review_average,
        sale_from,
        sale_to,
    } = item || {};
    let isSaleAvailable = compareWithTodaysDate(sale_from, sale_to);

    let [salePriceWidth, setSalePriceWidth] = useState();
    let [regularPriceWidth, setRegularPriceWidth] = useState();

    const handleLayoutSalePrice = (e) => {
        setSalePriceWidth(e.nativeEvent.layout.width);
    };
    const handleLayoutRegularPrice = (e) => {
        setRegularPriceWidth(e.nativeEvent.layout.width);
    };
    const productsStyle = ProductsStyle(salePriceWidth + regularPriceWidth);
    return (
        <View style={productsStyle.item}>
            <Pressable
                onPress={() => {
                    navigation.push(PRODUCT_DETAILS, {
                        slug: slug,
                        item
                    });
                }}
            >
                <View style={singleProductStyle.imageContainer}>
                    <View style={singleProductStyle.offerBadge}>
                        <ProductBadge
                            data={{
                                isOutOfStock,
                                featured,
                                offerCheck,
                                discountPercent,
                                review_average,
                            }}
                        />
                    </View>
                    <ProgressiveImage
                        source={{ uri: featured_image }}
                        style={singleProductStyle.img}
                    />
                </View>
            </Pressable>
            <CustomRating
                rating={Number(item?.review_average)}
                readOnly={true}
                starSize={dpr(18)}
                starStyle={productsStyle.start_mr}
            />
            <Pressable onPress={() => {
                    navigation.push(PRODUCT_DETAILS, {
                        slug: slug,
                        item
                    });
                }}>
                <Text style={productsStyle.text} numberOfLines={2}>
                    {name}
                </Text>
            </Pressable>
            <View style={productsStyle.priceCont}>
                <Text
                    style={productsStyle.price}
                    onLayout={handleLayoutSalePrice}
                >
                    {type == "Simple Product" ||
                    type == "External/Affiliate Product"
                        ? (isSaleAvailable && sale_price_formatted) ||
                          regular_price_formatted
                        : regular_price_formatted}
                </Text>
                {(type == "Simple Product" ||
                    type == "External/Affiliate Product") &&
                    isSaleAvailable &&
                    sale_price_formatted &&
                    regular_price_formatted && (
                        <Text
                            style={productsStyle.discount}
                            onLayout={handleLayoutRegularPrice}
                        >
                            {`${regular_price_formatted}`}
                        </Text>
                    )}
            </View>
        </View>
    );
};

export default memo(SingleProduct);
